/*******************************************************************************
ʵ鹦ܣڶʡ
ʱ䣺2017.12.23
ߣ⿵
*******************************************************************************/
#include <STC15F2K60S2.h>
#include <24c02.h>
#include <ds18b20.h>

#define uint unsigned int
#define uchar unsigned char

uchar code tab[12]={0xc0,0xf9,0xa4,0xb0,0x99,0x92,0x82,0xf8,0x80,0x90,0xbf,0xff};
uchar dsbuff[8]={11,11,11,11,11,11,11,11};
uchar DQTH,DQTL,temp;//趨¶ޱ
uchar discount;			 //ʾ
uchar flag;					 //ȡ¶ȵı־λ

/*******************************************************************************
ƣdelayms
ܣʱ
*******************************************************************************/
void delayms(uint xms)
{
	uint i,j;
	for(i=xms;i>0;i--)
	for(j=110;j>0;j--);
}

/*******************************************************************************
ƣdisplay
ܣʾ
*******************************************************************************/
void display()
{
	P2=0XEF;
	P0=0XFF;
	P2=0X1F;
	
	P2=0XCF;
	P0=1<<discount;
	P2=0X1F;
	
	P2=0XEF;
	P0=tab[dsbuff[discount]];
	P2=0X1F;
	
	if(++discount==8) discount=0;
}

/*******************************************************************************
ƣwarning
ܣPWM
*******************************************************************************/
void warning()
{
	static bit relay,pwmkey;
	if(DQTH<temp&&pwmkey==0)
		{
			pwmkey=1;
			TR1=1;	
		}
	if(DQTH>=temp&&pwmkey==1)
		{
			pwmkey=0;
			TR1=0;
			P34=1;
		}
	if(DQTL<=temp)
		{
			if(relay)
				{
					relay=0;
					P0=0x00;
					P2&=0x1f;
					P2|=0xa0;
					P2&=0x1f;	
				}
		}
	if(DQTL>temp)
		{
			if(relay==0)
				{
					relay=1;
					P0=0x00;
					P2&=0x1f;
					P2|=0xa0;
					P04=1;
					P2&=0x1f;
				}		
		}
}

/*******************************************************************************
ƣkey
ܣ
*******************************************************************************/
void key()
{
	if(P33==0)
		{
			delayms(10);
			if(P33==0)
				{
					DQTL--;
					if(DQTL>100) DQTL=0;
					at24c02_wirte(0x01,DQTL);
				}
				while(!P33);
		}
	
	if(P32==0)
		{
			delayms(10);
			if(P32==0)
				{
					DQTH--;
					if(DQTH>100) DQTH=0;
					if(DQTL>DQTH) DQTH=DQTL;
					at24c02_wirte(0x00,DQTH);
				}
			while(!P32);
		}
	
	if(P31==0)
		{
			delayms(10);
			if(P31==0)
				{
					DQTL++;
					if(DQTL>=100) DQTL=99;
					if(DQTL>DQTH) DQTL=DQTH;
					at24c02_wirte(0x01,DQTL);
				}
				while(!P31);
		}
	
	if(P30==0)
		{
			delayms(10);
			if(P30==0)
				{
					DQTH++;
					if(DQTH>=100) DQTH=99;
					at24c02_wirte(0x00,DQTH);
				}
				while(!P30);
		}
}
/*******************************************************************************
ƣTimer0Init
ܣʱ0ʼ
*******************************************************************************/
void Timer0Init(void)		//1@11.0592MHz
{
	AUXR |= 0x80;					//ʱʱ1Tģʽ
	TMOD &= 0xF0;					//öʱģʽ
	TL0 = 0xCD;						//öʱֵ
	TH0 = 0xD4;						//öʱֵ
	TF0 = 0;							//TF0־
	TR0 = 1;							//ʱ0ʼʱ
	EA=1;
	ET0=1;
}

/*******************************************************************************
ƣTimer1Init
ܣʱ1ʼ
*******************************************************************************/
void Timer1Init(void)		//100΢@11.0592MHz
{
	AUXR |= 0x40;					//ʱʱ1Tģʽ
	TMOD &= 0x0F;					//öʱģʽ
	TL1 = 0xAE;						//öʱֵ
	TH1 = 0xFB;						//öʱֵ
	EA=1;
	ET1=1;
}

/*******************************************************************************
ƣallinit
ܣӳʼ
*******************************************************************************/
void allinit()
{
		P2=0X80;P0=0XFF;
		P2=0XA0;P0=0X00;
		P2=0XC0;P0=0XFF;
		P2=0XE0;P0=0XFF;
}

/*******************************************************************************
ƣmain
ܣ
*******************************************************************************/
void main()
{
	allinit();							//ʼ
	DQTH=at24c02_read(0x00);//0x00ַ
	DQTL=at24c02_read(0x01);//0x01ַ
	Timer0Init();						//ʱ0ʼ
	Timer1Init();						//ʱ1ʼ
	while(1)
	{
			if(flag==1)					//ʱȡ¶
				{
					flag=0;
					temp=read_ds18b20();
				}
			warning();					//
			dsbuff[7]=temp%10;
			dsbuff[6]=temp/10;
			dsbuff[5]=11;
			dsbuff[4]=11;
			dsbuff[3]=DQTL%10;
			dsbuff[2]=DQTL/10;
			dsbuff[1]=DQTH%10;
			dsbuff[0]=DQTH/10;
	}
}

/*******************************************************************************
ƣTimer0
ܣʱ0жϷ
*******************************************************************************/
void Timer0() interrupt 1
{
	uint i;
	display();
	key();
	i++;
	if(i==4)
		{
			flag=1;
			i=0;
		}
}

/*******************************************************************************
ƣTimer1
ܣʱ1жϷ
*******************************************************************************/
void Timer1() interrupt 3
{
	static unsigned char i;
	if(i<3&&P34==0)
	P34=1;
	else if(i>3&&i<10&&P34==1)
	P34=0;
	i++;
	if(i==10)
	i=0;
}
